using System;
using Server;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;

namespace Server.Items
{
	public class BaseGoldEater : BaseMeleeWeapon
	{
		private int mEvolutionPoints = 0;
		private DateTime m_NextSpecial;
		private DateTime m_NextSpecial2;
		
		public virtual int GumpButton1 { get { return 30017; } }
		public virtual int GumpButton2 { get { return 30049; } }
		public virtual string RawWeaponName { get { return "Gold Eater"; } }
		
		public DateTime NextSpecial { get { return m_NextSpecial; } set { m_NextSpecial = value; } }
		public DateTime NextSpecial2 { get { return m_NextSpecial2; } set { m_NextSpecial2 = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int EvolutionPoints { get { return mEvolutionPoints; } set { mEvolutionPoints = value; } }
		
		public override int ArtifactRarity { get { return 500; } }
		public override int InitMinHits { get { return 255; } }
		public override int InitMaxHits { get { return 255; } }

		public BaseGoldEater( int itemID ) : base( itemID )
		{
			Name = RawWeaponName;
         Attributes.Luck = 100;
			Attributes.WeaponDamage = 1;
			Attributes.WeaponSpeed = 10;
			Attributes.SpellChanneling = 1;
		}
		
		public BaseGoldEater(Serial serial) : base(serial)
		{
		}
		
		public override bool OnEquip( Mobile from )
		{
			if ( from is PlayerMobile )
				this.BlessedFor = from;
			else if ( from is BaseCreature && ((BaseCreature)from).ControlMaster != null )
				this.BlessedFor = ((BaseCreature)from).ControlMaster;
			
			from.CloseGump( typeof(GoldEaterGump) );
			from.SendGump( new GoldEaterGump( this ) );
			
			this.InvalidateProperties();
			return base.OnEquip( from );
		}
		
		public override void OnRemoved(object parent)
		{
			if ( parent is Mobile )
				((Mobile)parent).CloseGump( typeof(GoldEaterGump) );
			
			base.OnRemoved(parent);
		}
		
		public override void OnHit(Mobile attacker, Mobile defender, double Damagebonus)
		{
			if ( SwordOfEvolution.ApplyGain( attacker, defender, this, ref mEvolutionPoints ) )
				this.Name = RawWeaponName + " (" + mEvolutionPoints.ToString() + ")";

			base.OnHit(attacker, defender,Damagebonus);
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=yellow>Gold Eater<basefont color=White>" );
		}
		
		public virtual void DoSpecial1( BaseGoldEater weap, Mobile from ) {}
		public virtual void DoSpecial2( BaseGoldEater weap, Mobile from ) {}
		
		private class GoldEaterGump : Gump
		{
			private BaseGoldEater m_Weap;
			
			public GoldEaterGump( BaseGoldEater weap ) : base( 300, 200 )
			{
				m_Weap = weap;
				Closable=false;
				Disposable=true;
				Dragable=true;
				Resizable=false;
				AddPage(0);
				AddBackground(30, 28, 37, 37, 9270);
				AddBackground(77, 28, 37, 37, 9270);
				AddImage(52, 7, 30063);
				AddImage(4, 7, 30063);
				AddImage(4, 7, 30070);
				AddImage(52, 7, 30064);
				AddButton(35, 32, m_Weap.GumpButton1, m_Weap.GumpButton1, 1, GumpButtonType.Reply, 0);
				AddButton(81, 32, m_Weap.GumpButton2, m_Weap.GumpButton2, 2, GumpButtonType.Reply, 0);
			}

			public override void OnResponse(NetState sender, RelayInfo info)
			{
				Mobile from = sender.Mobile;
				if ( m_Weap == null || m_Weap.Deleted || from == null || from.Weapon != m_Weap || from.HasTrade || from.Backpack == null )
					return;

				from.CloseGump( typeof(GoldEaterGump) );
				
            switch(info.ButtonID)
				{
					case 1:
						{
                     if ( DateTime.Now > m_Weap.NextSpecial )
                     {
                        m_Weap.DoSpecial1( m_Weap, from );
                     }
                     else
                     {
                        from.SendMessage( "Jeste nemuzes tuto abilitu pouzit!" );
                     }                     
                     break;
						}
					case 2:
						{
                     if ( DateTime.Now > m_Weap.NextSpecial2 )
                     {
                        m_Weap.DoSpecial2( m_Weap, from );
                     }
                     else
                     {
                        from.SendMessage( "Jeste nemuzes tuto abilitu pouzit!" );
                     }                     
                     break;
						}
				}
				
            from.SendGump( new GoldEaterGump( m_Weap ) );
			}
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)0);
			writer.Write(mEvolutionPoints);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
			mEvolutionPoints = reader.ReadInt();
		}
	}
}
